/************************************************************************
 * NAME:	tslist.h
 *
 * DESCR:	Track/sector list structures.
 *
 * NOTES:	- a track/sector (ts) list in this context refers to the
 *		  structure as it exists in the first "block" of a file
 *		  referenced by the catalog.  This includes the pointer
 *		  to the next ts as well as the sector offset.
 ************************************************************************/

typedef struct {
    ados_ts_ref		 next;		/* reference of next ts list		*/
    int			 sector_offset;	/* offset of first sector in this list ?????	*/
    int			 count;		/* number of track/sector references	*/
    int			 cursor;	/* position of enumeration cursor	*/
    ados_ts_ref		*list;		/* the array of track/sector references	*/
} ados_tslist;

/* ados_tslist_enumerate() - starts a walk through a tslist		*/
/* ados_tslist_next() - returns a ptr to the next ts_ref in this tslist	*/

#define ados_tslist_enumerate(a)	((a)->cursor = 0)
#define ados_tslist_next(a)		(((a)->cursor == (a)->count)?NULL:((a)->list+(((a)->cursor)++)))


extern ados_tslist *ados_tslist_read(struct adosfs *, ados_ts_ref *);
extern ados_tslist *ados_tslist_blank(struct adosfs *, int);
extern int ados_tslist_write(struct adosfs *, ados_ts_ref *, ados_tslist *);
